#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>

/**
 * A callback function invoked for each captured packet.
 */
void pcap_packet_cb(u_char* uparam,
	            const struct pcap_pkthdr* hdr,
		    const u_char* p_data)
{
    int i;
    static int packet_count = 0;

    packet_count++;

    /* lets dump the packet's data on screen. */
    printf("PACKET %d:\n", packet_count);
    for (i= 0; i < hdr->caplen; ++i) {
	printf(" 0x%x", *(p_data+i));
    }
    printf("\n\n");
}

int main(int argc, char* argv[])
{
    int snap_len = 40;          /* we only count - don't copy too much data. */
    int read_timeout_ms = 50;	/* to reduce switching into kernel space.    */
    char err_buf[PCAP_ERRBUF_SIZE]; /* here we'll get error strings. */
    int num_packets_to_capture = 10;
    int rc;

    /* open the device for capturing. */
    pcap_t* pc = pcap_open_live("ppp0",
		    		snap_len,
				0 /*not promiscous*/,
				read_timeout_ms,
				err_buf);
    if (!pc) {
	fprintf(stderr, "Error initializing pcap: %s\n", err_buf);
	exit(1);
    }

    /* capture num_packets_to_capture packets. */
    rc = pcap_loop(pc, num_packets_to_capture, pcap_packet_cb, NULL);
    if (rc == -1)
	pcap_perror(pc, argv[0]);

    /* cleanup - close the device. */
    pcap_close(pc);

    return 0;
}
